#!/usr/bin/env python
import web
import RPi.GPIO as GPIO, time, os

#########
# ledpixel_web.py
#
# 2016 by Fjedern - david@nlsn.nu
#########

# Control variables
#
# Total pixels
total_pixels = 149

#######
# Start - Code to control LED-strip
# Copied from Adafruit_LEDpixels.py
# https://github.com/adafruit/Adafruit-Raspberry-Pi-Python-Code/blob/master/Adafruit_LEDpixels/Adafruit_LEDpixels.py
#
#######

DEBUG = 1
GPIO.setmode(GPIO.BCM)

SPICLK = 18
SPIDO = 17

ledpixels = [0] * total_pixels
ledpixels_off = [0] * total_pixels

def slowspiwrite(clockpin, datapin, byteout):
    GPIO.setup(clockpin, GPIO.OUT)
    GPIO.setup(datapin, GPIO.OUT)
    for i in range(8):
        if (byteout & 0x80):
            GPIO.output(datapin, True)
        else:
            GPIO.output(clockpin, False)
        byteout <<= 1
        GPIO.output(clockpin, True)
        GPIO.output(clockpin, False)

def writestrip(pixels):
    spidev = file("/dev/spidev0.0", "w")
    for i in range(len(pixels)):
        spidev.write(chr((pixels[i]>>16) & 0xFF))
        spidev.write(chr((pixels[i]>>8) & 0xFF))
        spidev.write(chr(pixels[i] & 0xFF))
    spidev.close()
    time.sleep(0.002)

def Color(r, g, b):
    return ((r & 0xFF) << 16) | ((g & 0xFF) << 8) | (b & 0xFF)

def setpixelcolor(pixels, n, r, g, b):
    if (n >= len(pixels)):
        return
    pixels[n] = Color(r,g,b)

def setpixelcolor(pixels, n, c):
    if (n >= len(pixels)):
        return
    pixels[n] = c

def colorwipe(pixels, c, delay):
    for i in range(len(pixels)):
        setpixelcolor(pixels, i, c)
        writestrip(pixels)
        time.sleep(delay)       


###
# End of code from Adafruit
###########################

###
# Code to run web backend by Fjedern
###########################

led_status = False

GREEN = Color(0,80,0)
RED = Color(80,0,0)
PURPLE = Color(80,0,80)
BLUE = Color(0,102,255)

# Array to turn pixels off but still keep old color in ledpixels array
for lampa in range(len(ledpixels_off)):
    setpixelcolor(ledpixels_off, lampa, Color(0,0,0))

# Use template engine, templates in directory templates
render = web.template.render('templates/')

# Define URLs to classes
urls = (
    '/','index',
    '/onoff','onoff',
    '/images/(.*)', 'images',
    '/green','green',
    '/purple','purple',
    '/red','red',
    '/blue','blue'
)

class images:
    def GET(self,name):
        ext = name.split(".")[-1]

        cType = {
            "png":"images/png",
            "jpg":"images/jpg",
            "gif":"images/gif",
            "ico":"images/x-icon"       }

        if name in os.listdir('images'):
            web.header("Content-Type", cType[ext])
            return open('images/%s'%name,"rb").read()
        else:
            raise web.notfound()

# First page, from template directory
class index:
    def GET(self):
        global led_status
        return render.index(led_status)

# On off function
class onoff:                            
    def GET(self):
        global led_status
        if led_status == True :
            writestrip(ledpixels_off)
            led_status = False
        else:
            # All red
            writestrip(ledpixels)
            led_status = True
        raise web.seeother('/')

# Color functions
class green:
    def GET(self):
        global led_status
        for lampa in range(len(ledpixels)):
               setpixelcolor(ledpixels, lampa, GREEN)
        writestrip(ledpixels)
        led_status = True
        raise web.seeother('/')

class red:
    def GET(self):
        global led_status
        for lampa in range(len(ledpixels)):
               setpixelcolor(ledpixels, lampa, RED)
        writestrip(ledpixels)
        led_status = True
        raise web.seeother('/')

class purple:
    def GET(self):
        global led_status
        for lampa in range(len(ledpixels)):
               setpixelcolor(ledpixels, lampa, PURPLE)
        writestrip(ledpixels)
        led_status = True
        raise web.seeother('/')

class blue:
    def GET(self):
        global led_status
        for lampa in range(len(ledpixels)):
               setpixelcolor(ledpixels, lampa, BLUE)
        writestrip(ledpixels)
        led_status = True
        raise web.seeother('/')

# Start web
app = web.application(urls, globals())
if __name__ == "__main__":
    app.run()
